/**
 * Support for displaying of modal dialog windows
 * @type {{show, hide}}
 */
mods.modal = function($) {

    function Modal(id) {
        this.id = id;

        this.show = function() {
            mods.modal.show(this.id);
        };

        this.hide = function() {
            mods.modal.hide(this.id);
        }

        this.cancel = function() {
            if (this.onCancel) {
                this.onCancel(this);
            }
            this.hide();
        }

    }

    return {
        /**
         * Show the dialog box represented by the given element ID
         * @param id
         */
        show: function(id) {
            var e = $('#' + id);
            e.removeClass('dlg-hidden');
            var wrapper = e.find('.dlg-wrapper').removeClass('fade');
            var window = e.find('.dlg-window').removeClass('fade');
            setTimeout(function() {
                wrapper.addClass('fade');
                window.addClass('fade');
            }, 10);
        },

        hide: function(id) {
            var e = $('#' + id);
            e.find('.fade').removeClass('fade');
            setTimeout(function () {
                // close window
                e.addClass('dlg-hidden');
                // inform about window closing
                var opts = mods.app.showMessage.options;
                if (opts) {
                    delete mods.app.showMessage.options;
                }
            }, 200);
        },

        /**
         * Create a new modal window based on the options
         * @param opts object of format (id, width, header, content, footer)
         */
        create: function(opts) {
            var html = '<div id="' + opts.id + '" class="dialog dlg-hidden">' +
                '<div class="dlg-wrapper">' +
                '<div class="dlg-window" ' +
                    (opts.width ? ' style="width:' + opts.width + '"' : '') + '>' +
                (opts.showCloseIcon ?
                    '<a id="btn-close-icon" class="dlg-close-btn"> ' +
                    '<i class="icon-remove"/>' +
                    '</a>': '') +
                (opts.header ?
                    '<div class="dlg-header">' +
                        opts.header +
                    '</div>' : '') +
                (opts.content ? '<div class="dlg-content">' + opts.content + '</div>' : '') +
                (opts.footer ? '<div class="dlg-footer">' + opts.footer + '</div>' : '')
                 +
                '</div></div>';
            var elem = document.getElementById(opts.id);

            if (elem) {
                $(elem).remove();
            }

            var modalDlg = new Modal(opts.id);

            // adiciona o código HTML na página
            $('#modals').append(html);

            var selector = '#' + opts.id + ' #btn-close-icon';
            $(selector).click(function() {
                modalDlg.cancel();
            });

            return modalDlg;
        }
    };
}(jQuery);